#ifndef GINTENLIB_INCLUDED_MEMBERWISE_SWAP_HPP_
#define GINTENLIB_INCLUDED_MEMBERWISE_SWAP_HPP_

/*

      <gintenlib/memberwise_swap.hpp>

  memberwise_swap ： メンバ変数の swap

  宣言：
    template< typename T, typename Args... >
    void memberwise_swap( T& one, T& another, Args... mem_ptr... );

  機能：
    one.swap( another ); を呼び出す friend 関数 swap を定義します
  
*/

#include <algorithm> // for std::swap

#include <boost/preprocessor/arithmetic/inc.hpp>
#include <boost/preprocessor/cat.hpp>
#include <boost/preprocessor/repetition/enum_params.hpp>
#include <boost/preprocessor/repetition/enum_binary_params.hpp>
#include <boost/preprocessor/repetition/repeat_from_to.hpp>

namespace gintenlib
{
  #define GINTENLIB_GEN_SWAP_( z, n, mp ) \
    swap( one.*BOOST_PP_CAT( mp, n ), another.*BOOST_PP_CAT( mp, n ) );
  
  #define GINTENLIB_GEN_( z, n, unused_ )                       \
    template<typename T, BOOST_PP_ENUM_PARAMS( n, typename M )> \
    inline void memberwise_swap( T& one, T& another,            \
      BOOST_PP_ENUM_BINARY_PARAMS( n, M, T::*mp ) )             \
    {                                                           \
      using std::swap;                                          \
      BOOST_PP_REPEAT_FROM_TO( 0, n, GINTENLIB_GEN_SWAP_, mp )  \
    }
    // #define GINTENLIB_GEN_( z, n, unused_ )
  
  BOOST_PP_REPEAT_FROM_TO( 1, 10, GINTENLIB_GEN_, _ )
  
  #undef GINTENLIB_GEN_
  #undef GINTENLIB_GEN_SWAP_

} // namespace gintenlib

#endif  // #ifndef GINTENLIB_INCLUDED_MEMBERWISE_SWAP_HPP_
