#ifndef GINTENLIB_INCLUDED_TO_STRING_HPP_
#define GINTENLIB_INCLUDED_TO_STRING_HPP_

/*

      <gintenlib/to_string.hpp>

  to_string ： 文字列変換
  
  宣言：
    // stringstream によって std::string に変換する
    template<typename T>
    std::string to_string( const T& src );
    
    // 同じ。ただしより適切な to_string がある場合にはそちらを呼ぶ
    template<typename T>
    std::string to_str( const T& src );

  機能：
    文字列に変換する。
    boost::lexical_castより（たぶん）高速
    std::to_string ができるまでの繋ぎ

*/

#include <string>
#include <sstream>

namespace gintenlib
{
  template<typename T>
  inline std::string to_string( const T& src )
  {
    // 処理も見たままである
    std::ostringstream oss;
    oss << src;
    
    return oss.str();
  }
  
  // ADL によって to_string を呼び出す
  // いわゆる boost::swap 的なもの
  template<typename T>
  inline std::string to_str( const T& src )
  {
    return to_string( src );
  }

}   // namespace gintenlib


#endif  // #ifndef GINTENLIB_INCLUDED_TO_STRING_HPP_
