#include "../gintenlib/cast.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

using gintenlib::cast;

void test1()
{
  // オーバーロードのチェック
  struct
  {
    int operator()(int)    { return 1; }
    int operator()(double) { return 2; }
    int operator()(void*)  { return 3; }
  } f;
  
  BOOST_CHECK( f(0) == 1 );
  BOOST_CHECK( f( cast<double>(0) ) == 2 );
  BOOST_CHECK( f( cast<void*>(0) ) == 3 );
}

// ユーザ定義型
struct base {};
struct derived : base {};

void test2()
{
  struct
  {
    int operator()( const base&  )   { return 1; }
    int operator()( const derived& ) { return 2; }
    
  } f;
  
  base b; derived d;
  
  // 特に意味のないチェック
  BOOST_CHECK( f( b ) == 1 );
  BOOST_CHECK( f( d ) == 2 );
  
  // derived -> base へのキャスト
  // 値
  BOOST_CHECK( f(  cast<base >( d) ) == 1 );
  // ポインタ
  BOOST_CHECK( f( *cast<base*>(&d) ) == 1 );
  // 参照
  BOOST_CHECK( f(  cast<base&>( d) ) == 1 );
  
  // base -> derived へのキャスト（ダメ）
  // 値
  // BOOST_CHECK( f(  cast<derived >( b) ) == 2 );
  // ポインタ
  // BOOST_CHECK( f( *cast<derived*>(&b) ) == 2 );
  // 参照
  // BOOST_CHECK( f(  cast<derived&>( b) ) == 2 );
}


int test_main( int, char** )
{
  // コンパイルが通った時点で殆どテスト成功
  test1();
  test2();
  
  return 0;
}
