// ヘッダ
#include "../gintenlib/deep_ptr.hpp"

// 仮テストコードなので
// boost.test はまだ使わない。
// 出力、見づらいけど何が起こってるかは分かるよね？

#include <iostream>
using namespace std;

// デバッグ用マクロ
#define PRINT_AND_EXECUTE( expr ) \
  cout << #expr << ";\n"; expr

#define PRINT_EXPR( expr ) \
  cout << #expr << " -> " << (expr) << endl


// テスト１、ちゃんと使えるか調べる

// 持たせるクラス
struct hoge
{
  hoge()
  {
    cout << "hoge::hoge();\n";
  }
  
  hoge( const hoge& )
  {
    cout << "hoge::hoge( const hoge& );\n";
  }
  
  ~hoge() throw ()
  {
    cout << "hoge::~hoge();\n";
  }
  
};

void test_hoge()
{
  // コンストラクタのチェック
  gintenlib::deep_ptr<hoge> p1, p2( new hoge() );
  gintenlib::deep_ptr<const hoge> p3 = p2;
  
  // 代入チェック
  // 中身をコピーするので const からの代入も出来る
  PRINT_AND_EXECUTE( p2 = p3 );
  
  // reset チェック
  PRINT_AND_EXECUTE( p1.reset( new hoge() ) );
  PRINT_AND_EXECUTE( p2.reset() );
  
  // swap で余計なオブジェクトが作られないことをチェック
  PRINT_AND_EXECUTE( swap( p1, p2 ) );
  
  // shared_ptr への変換チェック
  PRINT_AND_EXECUTE( to_shared( p1 ) );
  PRINT_AND_EXECUTE( to_shared( p2 ) );
  PRINT_AND_EXECUTE( to_shared( p3 ) );
  
  // 抜けるよー
  cout << "leaving test_hoge().\n";
}

// pimpl で使うと割と便利そうだが
// サンプルは未完成

int main()
{
  test_hoge();
  
  return 0;
}

