#include "../gintenlib/factorize.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

#include <vector>
#include <iterator>
using namespace std;

// チェック用関数
template<typename T, size_t N>
inline void check( T x, const T (&ans)[N] )
{
  // とりあえずコンテナを用意
  vector<T> v;
  // 最初に v の領域を確保しておく（ factorize 失敗後のテストで領域違反しないため）
  v.reserve(N);
  
  // 本体
  gintenlib::factorize( x, back_inserter(v) );
  
  // 要素数のチェック
  BOOST_CHECK( v.size() == N );
  
  // 各因数のチェック
  for( size_t i = 0; i < N; ++i )
  {
    BOOST_CHECK( v[i] == ans[i] );
  }
}

int test_main( int, char** )
{
  // 12 * 23 * 42 = 11592 = 2 * 2 * 2 * 3 * 3 * 7 * 23 を因数分解
  {
    int ans[] = { 2, 2, 2, 3, 3, 7, 23 };
    check( 12 * 23 * 42, ans );
  }
  
  // 8191（素数） を因数分解
  {
    int ans[] = { 8191 };
    check( 8191, ans );
  }
  
  // 1024 = 2 ** 10 を因数分解
  {
    int ans[] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 };
    check( 1024, ans );
  }
  
  // おわり
  return 0;
}
