#include "../gintenlib/instance_counter.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

// 常に T::use_count == count_instances<T>
template<typename T>
int check_count()
{
  int count = T::use_count();
  BOOST_CHECK( count == gintenlib::count_instances<T>() );
  
  return count;
}


// テスト用クラス
struct hoge
  : gintenlib::instance_counter<hoge>
{
};

// use_count 静的関数はあるけど、
// gintenlib::instance_counter からは継承してないクラス
struct fuga
{
  static int use_count(){ return -1; }
};

int test_main( int, char** )
{
  // カウントの初期値はゼロ
  BOOST_CHECK( check_count<hoge>() == 0 );

  {
    // オブジェクトを作る
    hoge h;
    BOOST_CHECK( check_count<hoge>() == 1 );
    
    // コピーする
    hoge h2 = h;
    BOOST_CHECK( check_count<hoge>() == 2 );
    
    // スコープ開放チェック
    {
      int count = check_count<hoge>();
      static const int n = 10;
      
      // 配列
      {
        // n 個の hoge を作れば、カウントは n 増える
        hoge a[n];
        BOOST_CHECK( check_count<hoge>() == count + n );
        // warning 対策
        (void)a[0];
      }
      // 開放されるとカウントはスコープ入り前の値に戻るはず
      BOOST_CHECK( check_count<hoge>() == count );
      
      // new & delete
      hoge* p = new hoge();
      BOOST_CHECK( check_count<hoge>() == count + 1 );
      delete p; p = 0;
      BOOST_CHECK( check_count<hoge>() == count );
      
      // 配列の new & delete
      p = new hoge[n];
      BOOST_CHECK( check_count<hoge>() == count + n );
      delete [] p; p = 0;
      BOOST_CHECK( check_count<hoge>() == count );
    }
  }
  
  // 全てのインスタンスがなくなった
  BOOST_CHECK( check_count<hoge>() == 0 );
  
  // おまけ。カウントのそもそも存在しないものに count_instances を使うと
  // check_count<fuga>(); // コンパイルエラー
  
  return 0;
}
