// ヘッダ
#include "../gintenlib/reference_counter.hpp"

// 仮テストコードなので
// boost.test はまだ使わない。

#include <iostream>
using namespace std;

// 通常版
struct fast_ver
  : gintenlib::reference_counter<fast_ver>
{
  fast_ver()
  {
    cout << "fast_ver::fast_ver();\n";
  }
  
  ~fast_ver() throw ()
  {
    cout << "fast_ver::~fast_ver();\n";
  }
  
};

// 多重継承版
struct base1
  : gintenlib::reference_counter<base1, true>
{
  base1()
  {
    cout << "base1::base1();\n";
  }
  
  virtual ~base1() throw ()
  {
    cout << "base1::~base1();\n";
  }
  
};
struct base2
  : gintenlib::reference_counter<base2, true>
{
  base2()
  {
    cout << "base2::base2();\n";
  }
  
  virtual ~base2() throw ()
  {
    cout << "base2::~base2();\n";
  }
  
};
// 二つのクラスから派生する
// 普通はどっちのカウントを使っていいか分からずコンパイル通らない
struct derived
  : base1, base2
{
  derived()
  {
    cout << "derived::derived();\n";
  }
  
  virtual ~derived() throw ()
  {
    cout << "derived::~derived();\n";
  }
  
};

// デバッグ用マクロ
#define PRINT_AND_EXECUTE( expr ) \
  cout << #expr << ";\n"; expr

#define PRINT_EXPR( expr ) \
  cout << #expr << " -> " << (expr) << endl

#include <boost/intrusive_ptr.hpp>


int main()
{
  using boost::intrusive_ptr;
  
  // 通常版
  {
    intrusive_ptr<fast_ver> p1 = new fast_ver(), p2;
    
    PRINT_EXPR( p1->use_count() );
    PRINT_AND_EXECUTE( p2 = p1 );
    PRINT_EXPR( p1->use_count() );
    PRINT_AND_EXECUTE( p1.reset() );
    PRINT_EXPR( p2->use_count() );
    PRINT_AND_EXECUTE( p2.reset() );
  }
  
  // 多重継承版
  {
    intrusive_ptr<derived> p0 = new derived();
    intrusive_ptr<base1> p1;
    intrusive_ptr<base2> p2;
    
    PRINT_EXPR( p0->use_count() );
    PRINT_AND_EXECUTE( p1 = p0 );
    PRINT_EXPR( p0->use_count() );
    PRINT_AND_EXECUTE( p2 = p0 );
    PRINT_EXPR( p0->use_count() );
    PRINT_AND_EXECUTE( p0.reset() );
    PRINT_EXPR( p1->use_count() );
    PRINT_AND_EXECUTE( p2.reset() );
    PRINT_EXPR( p1->use_count() );
    
    cout << "scope out.\n";
  }
  
  return 0;
}

