#include "../gintenlib/swappable.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

// 使用例（名前空間に入れてみる）
namespace ns
{
  struct hoge
    : private gintenlib::swappable<hoge>
  {
    static bool swap_has_called;

    void swap( hoge& )
    {
      swap_has_called = true;
    }
    
  };
  bool hoge::swap_has_called = false;
  
} // namespace ns

#include <algorithm>  // for std::swap

// テスト本体
int test_main( int, char** )
{
  ns::hoge::swap_has_called = false;
  
  ns::hoge h1, h2;
  using std::swap;
  
  BOOST_CHECK( !ns::hoge::swap_has_called );
  swap( h1, h2 );
  BOOST_CHECK(  ns::hoge::swap_has_called );
  
  return 0;
}
