#include "../gintenlib/value_saver.hpp"
#include "../gintenlib/typed_saver.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

// テスト本体はテンプレートで記述
template<typename T, typename Saver>
void test( const T& x0, const T& x1 )
{
  T x = x0;
  
  {
    // とりあえず x の値をチェック
    BOOST_CHECK( x == x0 );
    
    // 保存
    Saver saver(x);
    // saver に突っ込んだ時点では値は変わらない
    BOOST_CHECK( x == x0 );
    
    // 値を変更
    x = x1;
    BOOST_CHECK( x == x1 );
    
    // ここで元に戻るはず
  }
  BOOST_CHECK( x == x0 );
  x = x0;
  {
    // また保存
    Saver saver(x);
    // 値を変更
    x = x1;
    BOOST_CHECK( x == x1 );
    
    // 明示的な値の復元
    saver.invoke();
    // 復元できたかチェック
    BOOST_CHECK( x == x0 );
    
    // invoke() 後もきちっと復帰してくれる
    x = x1;
  }
  BOOST_CHECK( x == x0 );
  x = x0;
  {
    // また保存
    Saver saver(x);
    // 値を変更
    x = x1;
    BOOST_CHECK( x == x1 );
    
    // 復元をしない
    saver.release();
    // 値は変更されない
    BOOST_CHECK( x == x1 );
  }
  // 復元されない
  BOOST_CHECK( x == x1 );
  x = x0;
  {
    // また保存
    Saver saver(x);
    // 値を変更
    x = x1;
    BOOST_CHECK( x == x1 );
    
    // 復帰してから解放
    saver.reset();
    // 復帰されたかチェック
    BOOST_CHECK( x == x0 );
    
    // 値を変更しても
    x = x1;
  }
  // 復元されないかチェック
  BOOST_CHECK( x == x1 );
}

template<typename T>
void test_saver( const T& x0, const T& x1 )
{
  // 型付と汎用、両方テスト
  test< T, gintenlib::typed_saver<T> >( x0, x1 );
  test< T, gintenlib::value_saver    >( x0, x1 );
}

#include <complex>
#include <boost/shared_ptr.hpp>

int test_main( int, char** )
{
  // 組み込み型
  test_saver<int>( 0, 1 );
  
  // ユーザ定義型（ e.g. std::complex ）
  std::complex<double> j( 0, 1 );
  test_saver< std::complex<double> >( 1.0, j );
  
  // ユーザ定義型そのに、boost::shared_ptr
  boost::shared_ptr<int> p0, p1( new int(0) );
  test_saver< boost::shared_ptr<int> >( p0, p1 );
  
  return 0;
}
