package jp.sourceforge.glad.example.domain.common.value;

import java.math.BigDecimal;

public class Money extends Quantity {

	public static final Money ZERO = new Money(BigDecimal.ZERO);

	public Money(BigDecimal amount) {
		super(amount);
	}

	public Money add(Money x) {
		return new Money(getAmount().add(x.getAmount()));
	}

	public Money multiply(int x) {
		return new Money(getAmount().multiply(BigDecimal.valueOf(x)));
	}

}
