package example.hello.manager.impl;

import javax.ejb.Stateless;

import example.common.exception.ApplicationRuntimeException;
import example.common.exception.SystemException;
import example.hello.exception.HelloException;
import example.hello.exception.HelloRollbackException;
import example.hello.exception.HelloRuntimeException;
import example.hello.manager.CommandMgr;

/**
 * EJB における例外の振る舞いを確認するための SessionBean です。
 * 
 * @author glad
 */
@Stateless
public class CommandMgrBean implements CommandMgr {

    public void doCommand(String command) throws HelloException {
        if ("#he".equals(command)) {
            // 検査例外。ロールバックしない。
            throw new HelloException("sayHello failed");
        } else if ("#he.ro".equals(command)) {
            // 検査例外。ロールバックする。
            throw new HelloException("sayHello failed").setRollbackOnly();
        } else if ("#hbe".equals(command)) {
            // 検査例外。ロールバックする。
            throw new HelloRollbackException("sayHello failed");
        } else if ("#hre".equals(command)) {
            // 非検査例外。@ApplicationException を指定。ロールバックする。
            throw new HelloRuntimeException("sayHello failed");
        } else if ("#are".equals(command)) {
            // 非検査例外。@ApplicationException を指定。ロールバックする。
            throw new ApplicationRuntimeException("sayHello failed");
        } else if ("#se".equals(command)) {
            // 非検査例外。ejb-jar.xml の application-exception に登録。ロールバックする。
            throw new SystemException("sayHello failed");
        } else if ("#re".equals(command)) {
            // 非検査例外。ロールバックする。EJBException でラップされる。
            throw new RuntimeException("sayHello failed");
        } else {
            // エラー。ロールバックする。EJBException でラップされる。
            throw new Error("unknown command: " + command);
        }
    }

}
