package example.hello.service.ws.web;

import javax.jws.HandlerChain;
import javax.jws.WebService;

import example.common.util.ExampleUtils;
import example.hello.dto.HelloRequest;
import example.hello.dto.HelloResponse;
import example.hello.exception.HelloException;
import example.hello.service.HelloService;

@WebService(
        serviceName = "WsWebHelloService",
        portName = "HelloPort",
        endpointInterface = "example.hello.service.HelloService")
@HandlerChain(file = "/example/hello/service/ws/handler-chains.xml")
public class WsHelloServiceImpl implements HelloService {

    public HelloResponse sayHello(HelloRequest request) throws HelloException {
        HelloService service = ExampleUtils.jndiLookup(
                HelloService.class, "java:comp/env/ejb/HelloService");
        return service.sayHello(request);
    }

}
