/*
 * Copyright (C) 2008-2009 GLAD!! (ITO Yoshiichi)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.glad.calendar;

import java.util.TimeZone;

/**
 * カレンダーライブラリで使用する定数です。
 * 
 * @author GLAD!!
 */
public class CalendarConsts {

    // ---- Japanese Era (Java SE 6.0 互換)

    /** 明治以前 (0) */
    public static final int BEFORE_MEIJI = 0;

    /** 明治 (1) */
    public static final int MEIJI = 1;

    /** 大正 (2) */
    public static final int TAISHO = 2;

    /** 昭和 (3) */
    public static final int SHOWA = 3;

    /** 平成 (4) */
    public static final int HEISEI = 4;

    // ---- ISO 8601 (JIS X 0301): Month

    /** 1月 (1) */
    public static final int JANUARY = 1;

    /** 2月 (2) */
    public static final int FEBRUARY = 2;

    /** 3月 (3) */
    public static final int MARCH = 3;

    /** 4月 (4) */
    public static final int APRIL = 4;

    /** 5月 (5) */
    public static final int MAY = 5;

    /** 6月 (6) */
    public static final int JUNE = 6;

    /** 7月 (7) */
    public static final int JULY = 7;

    /** 8月 (8) */
    public static final int AUGUST = 8;

    /** 9月 (9) */
    public static final int SEPTEMBER = 9;

    /** 10月 (10) */
    public static final int OCTOBER = 10;

    /** 11月 (11) */
    public static final int NOVEMBER = 11;

    /** 12月 (12) */
    public static final int DECEMBER = 12;

    // ---- ISO 8601 (JIS X 0301): DayOfWeek

    /** 月曜日 (1) */
    public static final int MONDAY = 1;

    /** 火曜日 (2) */
    public static final int TUESDAY = 2;

    /** 水曜日 (3) */
    public static final int WEDNESDAY = 3;

    /** 木曜日 (4) */
    public static final int THURSDAY = 4;

    /** 金曜日 (5) */
    public static final int FRIDAY = 5;

    /** 土曜日 (6) */
    public static final int SATURDAY = 6;

    /** 日曜日 (7) */
    public static final int SUNDAY = 7;

    // ---- TimeZone

    /** 協定世界時 */
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    /** 日本標準時 */
    public static final TimeZone JST = TimeZone.getTimeZone("Asia/Tokyo");

}
