/*
 * Copyright (C) 2008-2009 GLAD!! (ITO Yoshiichi)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.glad.calendar.holiday;

import jp.sourceforge.glad.calendar.CalendarConsts;
import jp.sourceforge.glad.calendar.ISOCalendar;

/**
 * 振替休日。
 * 
 * @author GLAD!!
 */
public class SubstituteHoliday extends Holiday {

    private static final long serialVersionUID = 994586782503355172L;

    /** 適用開始日 (1973-04-29 の翌日) */
    static final ISOCalendar START =
            new ISOCalendar(1973, 4, 29, CalendarConsts.UTC);

    /**
     * オブジェクトを構築します。
     * 
     * @param country   国コード (ISO 3166-1 alpha-2)
     * @param name      名前
     * @param startYear 適用開始年
     * @param endYear   適用終了年
     */
    public SubstituteHoliday(
            String country, String name, Integer startYear, Integer endYear) {
        super(country, name, "??-??", startYear, endYear);
    }

    /**
     * {@inheritDoc}
     */
    public boolean isAvailableYear(int year) {
        return super.isAvailableYear(year) && (START.getYear() <= year);
    }

    /**
     * 指定された日に、この祝日が有効か判定します。
     * 
     * @param timeInMillisUTC 1970-01-01T00:00:00Z からのミリ秒数
     * @return 有効ならば true
     */
    public boolean isAvailableDate(long timeInMillisUTC) {
        return (START.getTimeInMillis() <= timeInMillisUTC);
    }

}
