package jp.sourceforge.glad.calendar.joda.format;

import static org.joda.time.format.ISODateTimeFormat.*;
import jp.sourceforge.glad.calendar.joda.chrono.JapaneseChronology;

import org.joda.time.format.DateTimeFormatter;

public class JapaneseDateTimeFormat {

    public static DateTimeFormatter jisDate() {
        return new DateTimeFormatterBuilder()
            .appendEraShortText()
            .appendYearOfEra(2, 2)
            .appendLiteral('.')
            .appendMonthOfYear(2)
            .appendLiteral('.')
            .appendDayOfMonth(2)
            .toFormatter()
            .withChronology(JapaneseChronology.getInstance());
    }

    public static DateTimeFormatter jisDateTime() {
        return new DateTimeFormatterBuilder()
            .append(jisDate())
            .append(tTime())
            .toFormatter()
            .withChronology(JapaneseChronology.getInstance());
    }

    public static DateTimeFormatter jisDateTimeNoMillis() {
        return new DateTimeFormatterBuilder()
            .append(jisDate())
            .append(tTimeNoMillis())
            .toFormatter()
            .withChronology(JapaneseChronology.getInstance());
    }

}
