package jp.sourceforge.glad.reflect;

public class NoSuchFieldRuntimeException extends ReflectionRuntimeException {

    private static final long serialVersionUID = -4816985044418743047L;

    public NoSuchFieldRuntimeException() {
    }

    public NoSuchFieldRuntimeException(String message) {
        super(message);
    }

    public NoSuchFieldRuntimeException(Throwable cause) {
        super(cause);
    }

    public NoSuchFieldRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public NoSuchFieldRuntimeException(NoSuchFieldException e) {
        this(e.getMessage(), e);
    }

    public NoSuchFieldException getNoSuchFieldException() {
        Throwable cause = getCause();
        if (NoSuchFieldException.class.isInstance(cause)) {
            return NoSuchFieldException.class.cast(cause);
        } else {
            return new NoSuchFieldException(getMessage());
        }
    }

}
