package jp.sourceforge.glad.calendar.holiday;

import java.util.Locale;

import junit.framework.TestCase;

/**
 * {@link VernalEquinoxDay} の単体テスト。
 * 
 * @author GLAD!!
 * @see http://www.nao.ac.jp/QA/faq/a0301.html
 * @see http://www.asahi-net.or.jp/~CI5M-NMR/misc/equinox.html
 */
public class VernalEquinoxDayTest extends TestCase {

    VernalEquinoxDay holiday;

    protected void setUp() throws Exception {
        holiday = new VernalEquinoxDay("JP", "Shunbun-no-hi", 1948, null);
    }

    protected void tearDown() throws Exception {
        holiday = null;
    }

    public void testBasic() {
        assertEquals("JP", holiday.getCountry());
        assertEquals("Shunbun-no-hi", holiday.getRawName());
        assertEquals("春分の日", holiday.getName());
        assertEquals("春分の日", holiday.getName(Locale.JAPAN));
        assertEquals("Vernal Equinox Day", holiday.getName(Locale.US));
        assertEquals(3, holiday.getMonth());
        assertEquals(0, holiday.getDayOfMonth());
        assertEquals(0, holiday.getWeekOfMonth());
        assertEquals(0, holiday.getDayOfWeek());
        assertEquals((Integer) 1948, holiday.getStartYear());
        assertNull(holiday.getEndYear());
        assertFalse(holiday.isAvailableYear(1947));
        assertTrue (holiday.isAvailableYear(1948));
        assertTrue (holiday.isAvailableYear(2008));
        assertEquals("Shunbun-no-hi: 03-??", holiday.toString());
    }

    // 2000年以前の日付は、官報の「暦要項」からの引用を参照。
    // http://www.asahi-net.or.jp/~CI5M-NMR/misc/equinox.html

    public void test1950s() {
        checkDate_equals("1950-03-21", 1950);
        checkDate_equals("1951-03-21", 1951);
        checkDate_equals("1952-03-21", 1952);
        checkDate_equals("1953-03-21", 1953);
        checkDate_equals("1954-03-21", 1954);
        checkDate_equals("1955-03-21", 1955);
        checkDate_equals("1956-03-21", 1956);
        checkDate_equals("1957-03-21", 1957);
        checkDate_equals("1958-03-21", 1958);
        checkDate_equals("1959-03-21", 1959);
    }

    public void test1960s() {
        checkDate_equals("1960-03-20", 1960);
        checkDate_equals("1961-03-21", 1961);
        checkDate_equals("1962-03-21", 1962);
        checkDate_equals("1963-03-21", 1963);
        checkDate_equals("1964-03-20", 1964);
        checkDate_equals("1965-03-21", 1965);
        checkDate_equals("1966-03-21", 1966);
        checkDate_equals("1967-03-21", 1967);
        checkDate_equals("1968-03-20", 1968);
        checkDate_equals("1969-03-21", 1969);
    }

    public void test1970s() {
        checkDate_equals("1970-03-21", 1970);
        checkDate_equals("1971-03-21", 1971);
        checkDate_equals("1972-03-20", 1972);
        checkDate_equals("1973-03-21", 1973);
        checkDate_equals("1974-03-21", 1974);
        checkDate_equals("1975-03-21", 1975);
        checkDate_equals("1976-03-20", 1976);
        checkDate_equals("1977-03-21", 1977);
        checkDate_equals("1978-03-21", 1978);
        checkDate_equals("1979-03-21", 1979);
    }

    public void test1980s() {
        checkDate_equals("1980-03-20", 1980);
        checkDate_equals("1981-03-21", 1981);
        checkDate_equals("1982-03-21", 1982);
        checkDate_equals("1983-03-21", 1983);
        checkDate_equals("1984-03-20", 1984);
        checkDate_equals("1985-03-21", 1985);
        checkDate_equals("1986-03-21", 1986);
        checkDate_equals("1987-03-21", 1987);
        checkDate_equals("1988-03-20", 1988);
        checkDate_equals("1989-03-21", 1989);
    }

    public void test1990s() {
        checkDate_equals("1990-03-21", 1990);
        checkDate_equals("1991-03-21", 1991);
        checkDate_equals("1992-03-20", 1992);
        checkDate_equals("1993-03-20", 1993);
        checkDate_equals("1994-03-21", 1994);
        checkDate_equals("1995-03-21", 1995);
        checkDate_equals("1996-03-20", 1996);
        checkDate_equals("1997-03-20", 1997);
        checkDate_equals("1998-03-21", 1998);
        checkDate_equals("1999-03-21", 1999);
    }

    // 2000 年以降の日付は、「国立天文台」のサイトを参照。
    // http://www.nao.ac.jp/QA/faq/a0301.html

    public void test2000s() {
        checkDate_equals("2000-03-20", 2000);
        checkDate_equals("2001-03-20", 2001);
        checkDate_equals("2002-03-21", 2002);
        checkDate_equals("2003-03-21", 2003);
        checkDate_equals("2004-03-20", 2004);
        checkDate_equals("2005-03-20", 2005);
        checkDate_equals("2006-03-21", 2006);
        checkDate_equals("2007-03-21", 2007);
        checkDate_equals("2008-03-20", 2008);
        checkDate_equals("2009-03-20", 2009);
    }

    public void test2010s() {
        checkDate_equals("2010-03-21", 2010);
        checkDate_equals("2011-03-21", 2011);
        checkDate_equals("2012-03-20", 2012);
        checkDate_equals("2013-03-20", 2013);
        checkDate_equals("2014-03-21", 2014);
        checkDate_equals("2015-03-21", 2015);
        checkDate_equals("2016-03-20", 2016);
        checkDate_equals("2017-03-20", 2017);
        checkDate_equals("2018-03-21", 2018);
        checkDate_equals("2019-03-21", 2019);
    }

    public void test2020s() {
        checkDate_equals("2020-03-20", 2020);
        checkDate_equals("2021-03-20", 2021);
        checkDate_equals("2022-03-21", 2022);
        checkDate_equals("2023-03-21", 2023);
        checkDate_equals("2024-03-20", 2024);
        checkDate_equals("2025-03-20", 2025);
        checkDate_equals("2026-03-20", 2026);
        checkDate_equals("2027-03-21", 2027);
        checkDate_equals("2028-03-20", 2028);
        checkDate_equals("2029-03-20", 2029);
    }

    public void test2030s() {
        checkDate_equals("2030-03-20", 2030);
    }

    void checkDate_equals(String expected, int year) {
        assertEquals(expected, holiday.getISOCalendar(year).formatDate());
    }

}
