package jp.sourceforge.glad.calendar.joda.format;

import junit.framework.TestCase;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ISODateTimeFormatTest extends TestCase {

    static final DateTimeZone UTC = DateTimeZone.UTC;
    static final DateTimeZone JST = DateTimeZone.forID("Asia/Tokyo");

    public void testCalendarDate() {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        DateTime dateTime = new DateTime(2008, 1, 23, 1, 12, 23, 123, JST);
        assertEquals("2008-01-23T01:12:23.123+09:00", fmt.print(dateTime));
        dateTime = dateTime.withZone(UTC);
        assertEquals("2008-01-22T16:12:23.123Z", fmt.print(dateTime));
    }

    public void testOrdinalDate() {
        DateTimeFormatter fmt = ISODateTimeFormat.ordinalDateTime();
        DateTime dateTime = new DateTime(2008, 1, 23, 1, 12, 23, 123, JST);
        assertEquals("2008-023T01:12:23.123+09:00", fmt.print(dateTime));
        dateTime = dateTime.withZone(UTC);
        assertEquals("2008-022T16:12:23.123Z", fmt.print(dateTime));
    }

    public void testWeekDate() {
        DateTimeFormatter fmt = ISODateTimeFormat.weekDateTime();
        DateTime dateTime = new DateTime(2008, 1, 23, 1, 12, 23, 123, JST);
        assertEquals("2008-W04-3T01:12:23.123+09:00", fmt.print(dateTime));
        dateTime = dateTime.withZone(UTC);
        assertEquals("2008-W04-2T16:12:23.123Z", fmt.print(dateTime));
        
        // 年末年始がともに前年の週に含まれる場合。
        DateTime dt20051231 = new DateTime(2005, 12, 31, 23, 59, 59, 999, JST);
        assertEquals("2005-W52-6T23:59:59.999+09:00", fmt.print(dt20051231));
        DateTime dt20060101 = new DateTime(2006, 1, 1, 0, 0, 0, 0, JST);
        assertEquals("2005-W52-7T00:00:00.000+09:00", fmt.print(dt20060101));
        // 年末年始がそれぞれの年の週に含まれる場合。
        DateTime dt20061231 = new DateTime(2006, 12, 31, 23, 59, 59, 999, JST);
        assertEquals("2006-W52-7T23:59:59.999+09:00", fmt.print(dt20061231));
        DateTime dt20070101 = new DateTime(2007, 1, 1, 0, 0, 0, 0, JST);
        assertEquals("2007-W01-1T00:00:00.000+09:00", fmt.print(dt20070101));
        // 年末年始がともに翌年の週に含まれる場合。
        DateTime dt20071231 = new DateTime(2007, 12, 31, 23, 59, 59, 999, JST);
        assertEquals("2008-W01-1T23:59:59.999+09:00", fmt.print(dt20071231));
        DateTime dt20080101 = new DateTime(2008, 1, 1, 0, 0, 0, 0, JST);
        assertEquals("2008-W01-2T00:00:00.000+09:00", fmt.print(dt20080101));
    }

}
