package jp.sourceforge.glad.collection.iteration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import jp.sourceforge.glad.collection.closure.ClosureSupport;
import jp.sourceforge.glad.collection.function.Function;
import junit.framework.TestCase;

public class MapValuesIterationHandlerTest extends TestCase {

    MapValuesIterationHandler<Long> handler;

    protected void setUp() throws Exception {
        Map<String, Long> source = new TreeMap<String, Long>();
        source.put("a", 1L);
        source.put("c", 2L);
        source.put("b", 3L);
        handler = new MapValuesIterationHandler<Long>(source);
    }

    protected void tearDown() throws Exception {
        handler = null;
    }

    public void testIterate() {
        final List<Long> target = new ArrayList<Long>();
        handler.iterate(new ClosureSupport<Long>() {
            public void execute(Long each) {
                target.add(each);
            }
        });
        assertEquals(3, target.size());
        assertEquals("[1, 3, 2]", target.toString());
    }

    public void testConvert() {
        IterationHandler<Double> adapter =
                new IterationHandlerAdapter<Long, Double>(handler,
        new Function<Long, Double>() {
            public Double apply(Long source) {
                return Double.valueOf(source);
            }
        });
        final List<Double> target = new ArrayList<Double>();
        adapter.iterate(new ClosureSupport<Double>() {
            public void execute(Double each) {
                target.add(each);
            }
        });
        assertEquals(3, target.size());
        assertEquals("[1.0, 3.0, 2.0]", target.toString());
    }

}
