package jp.sourceforge.glad.reflect;

import junit.framework.TestCase;

public class FieldAccessorTest extends TestCase {

    public void testAccess() {
        Example target = new Example("abc");
        FieldAccessor<String> fValue =
                new FieldAccessor<String>(target, "value");
        assertEquals("abc", fValue.get());
        fValue.set("def");
        assertEquals("def", target.getValue());
    }

    public static class Example {
        private String value;
        public Example(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }
    }

}
