package jp.sourceforge.glad.org.seasar.extension.unit;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;


public class S2TestCaseTest extends S2TestCase {

    @Override
    protected void setUp() throws Exception {
        include("j2ee.dicon");
    }

    public void testSetUpDbForClassTx() {
        setUpDbForClass("DEPT", "EMP");
    }

    public void testSetUpDbForMethodTx() {
        setUpDbForMethod("DEPT", "EMP");
    }

    public void testAssertDbTx() {
        assertDb("DEPT", "EMP");
    }

    public void testAssertDbForSuffixTx() {
        assertDbForSuffix("01", "DEPT", "EMP");
        assertDbForSuffix("02", "DEPT", "EMP");
    }

    public void testAssertDataBean() {
        Hoge bean = new Hoge("123");
        bean.addFuga("abc");
        bean.addFuga("def");
        assertData(bean);
    }

    @SuppressWarnings("unchecked")
    public void testAssertDataMap() {
        Map map = new LinkedHashMap();
        map.put("aaa", 123);
        assertData(map);
    }

    public void testAssertDataEmptyList() {
        try {
            assertData(new ArrayList<Hoge>());
            fail();
        } catch (IndexOutOfBoundsException e) {}
    }

    public void testAssertDataBeanList() {
        List<Hoge> beans = new ArrayList<Hoge>();
        Hoge bean1 = new Hoge("123");
        bean1.addFuga("abc");
        beans.add(bean1);
        Hoge bean2 = new Hoge("456");
        bean2.addFuga("def");
        beans.add(bean2);
        assertData(beans);
    }

    @SuppressWarnings("unchecked")
    public void testAssertDataMapList() {
        List maps = new ArrayList();
        Map map1 = new LinkedHashMap();
        map1.put("aaa", 123);
        maps.add(map1);
        Map map2 = new LinkedHashMap();
        map2.put("aaa", 456);
        maps.add(map2);
        assertData(maps);
    }

    public void testAssertDataEmptyArray() {
        try {
            assertData(new Hoge[0]);
            fail();
        } catch (IndexOutOfBoundsException e) {}
    }

    public void testAssertDataBeanArray() {
        Hoge[] beans = new Hoge[2];
        beans[0] = new Hoge("123");
        beans[0].addFuga("abc");
        beans[1] = new Hoge("456");
        beans[1].addFuga("def");
        assertData(beans);
    }

    public static class Hoge {
        String aaa;
        List<Fuga> fugas = new ArrayList<Fuga>();
        public Hoge() {}
        public Hoge(String aaa) {
            this.aaa = aaa;
        }
        public String getAaa() {
            return aaa;
        }
        public void setAaa(String aaa) {
            this.aaa = aaa;
        }
        public List<Fuga> getFugas() {
            return fugas;
        }
        public void addFuga(Fuga fuga) {
            fugas.add(fuga);
        }
        public void addFuga(String bbb) {
            addFuga(new Fuga(bbb));
        }
    }

    public static class Fuga {
        String bbb;
        public Fuga() {}
        public Fuga(String bbb) {
            this.bbb = bbb;
        }
        public String getBbb() {
            return bbb;
        }
        public void setBbb(String bbb) {
            this.bbb = bbb;
        }
        public String toString() {
            return "Fuga(" + bbb + ")";
        }
    }

}
