package haskell.prelude;

public class Function2<A, B, C>
        extends Function<A, Function<B, C>> {

    protected Function2() {
    }

    protected Function2(final java.lang.String name) {
        super(name);
    }

    /**
     * public static C name(A x, B x);
     */
    public Function2(
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String name) {
        super(name, clazz, returnType, name, 2);
    }

    /**
     * public C name(A x, B x);
     */
    public Function2(
            final Object target,
            final Class<?> returnType,
            final java.lang.String name) {
        super(name, target, returnType, name, 2);
    }

    /**
     * public static C methodName(A x, B x);
     */
    public Function2(
            final java.lang.String name,
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String methodName) {
        super(name, clazz, returnType, methodName, 2);
    }

    /**
     * public C methodName(A x, B x);
     */
    public Function2(
            final java.lang.String name,
            final Object target,
            final Class<?> returnType,
            final java.lang.String methodName) {
        super(name, target, returnType, methodName, 2);
    }

    /**
     * public static T methodName(A x, B x, ...);
     */
    protected Function2(
            final java.lang.String name,
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String methodName,
            final int nParams) {
        super(name, clazz, returnType, methodName, nParams);
    }

    /**
     * public T methodName(A x, B x, ...);
     */
    protected Function2(
            final java.lang.String name,
            final Object target,
            final Class<?> returnType,
            final java.lang.String methodName,
            final int nParams) {
        super(name, target, returnType, methodName, nParams);
    }

    /**
     * public static C name(A x, B y);
     */
    public Function2(
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String name,
            final Class<A> typeA,
            final Class<B> typeB) {
        super(name, clazz, returnType, name, typeA, typeB);
    }

    /**
     * public C name(A x, B y);
     */
    public Function2(
            final Object target,
            final Class<?> returnType,
            final java.lang.String name,
            final Class<A> typeA,
            final Class<B> typeB) {
        super(name, target, returnType, name, typeA, typeB);
    }

    /**
     * public static T methodName(A x, B y, ...);
     */
    public Function2(
            final java.lang.String name,
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String methodName,
            final Class<?>... paramTypes) {
        super(name, clazz, returnType, methodName, paramTypes);
    }

    /**
     * public T methodName(A x, B y, ...);
     */
    public Function2(
            final java.lang.String name,
            final Object target,
            final Class<?> returnType,
            final java.lang.String methodName,
            final Class<?>... paramTypes) {
        super(name, target, returnType, methodName, paramTypes);
    }

    /**
     * f x
     */
    @Override
    public final Function<B, C> apply(final A x) {
        return new Function<B, C>(toString(x)) {
            @Override
            public C apply(final B y) {
                return Function2.this.apply(x, y);
            }
        };
    }

    /**
     * f x y
     */
    public C apply(final A x, final B y) {
        return $internal().apply(this, x, y);
    }

}
