package haskell.test;

import haskell.prelude.Bool;
import haskell.prelude.Char;
import haskell.prelude.Int;
import haskell.prelude.Ordering;
import haskell.prelude.String;
import junit.framework.TestCase;

public abstract class HaskellTestCase extends TestCase {

    public static void assertFalse(final Bool value) {
        assertEquals(Bool.False(), value);
    }

    public static void assertTrue(final Bool value) {
        assertEquals(Bool.True(), value);
    }

    public static void assertLT(final Ordering value) {
        assertEquals(Ordering.LT(), value);
    }

    public static void assertEQ(final Ordering value) {
        assertEquals(Ordering.EQ(), value);
    }

    public static void assertGT(final Ordering value) {
        assertEquals(Ordering.GT(), value);
    }

    public static void assertEquals(
            final int expected, final Int actual) {
        assertEquals(Int.valueOf(expected), actual);
    }

    public static void assertEquals(
            final char expected, final Char actual) {
        assertEquals(Char.valueOf(expected), actual);
    }

    public static void assertEquals(
            final java.lang.String expected, final String actual) {
        assertEquals(String.valueOf(expected), actual);
    }

}
