package example.hello.client;

import example.hello.dto.HelloRequest;
import example.hello.exception.HelloException;
import example.hello.exception.HelloRuntimeException;
import example.hello.service.HelloService;

public class HelloClient {

    HelloService service;

    public HelloClient(HelloService service) {
        this.service = service;
    }

    public String sayHello(String name) {
        HelloRequest request = new HelloRequest();
        if (name != null) {
            request.setName(name);
        }
        try {
            return service.sayHello(request).getMessage();
        } catch (HelloException e) {
            throw new HelloRuntimeException(e);
        }
    }

}
