package example.javax.ejb;

import java.security.Identity;
import java.security.Principal;
import java.util.Properties;

import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.TimerService;
import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

@SuppressWarnings("deprecation")
public class MockEJBContext implements EJBContext {

    @Resource
    UserTransaction userTransaction;

    public EJBHome getEJBHome() {
        throw new UnsupportedOperationException();
    }

    public EJBLocalHome getEJBLocalHome() {
        throw new UnsupportedOperationException();
    }

    public Properties getEnvironment() {
        throw new UnsupportedOperationException();
    }

    public Identity getCallerIdentity() {
        throw new UnsupportedOperationException();
    }

    public Principal getCallerPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isCallerInRole(Identity role) {
        throw new UnsupportedOperationException();
    }

    public boolean isCallerInRole(String roleName) {
        throw new UnsupportedOperationException();
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        return userTransaction;
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        try {
            return (userTransaction.getStatus() == Status.STATUS_MARKED_ROLLBACK);
        } catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        try {
            userTransaction.setRollbackOnly();
        } catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public TimerService getTimerService() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public Object lookup(String name) {
        throw new UnsupportedOperationException();
    }

}
