package example.common.util;

import example.common.util.ExampleUtils;
import junit.framework.TestCase;

/**
 * {@link ExampleUtils} の単体テスト。
 * 
 * @author glad
 */
public class ExampleUtilsTest extends TestCase {

    public void testGetArg() {
        String[] args = {"a", "b"};
        assertEquals("a", ExampleUtils.getArg(args, 0));
        assertEquals("b", ExampleUtils.getArg(args, 1));
        assertNull(ExampleUtils.getArg(args, 2));
    }

    public void testIsBlank() {
        assertTrue(ExampleUtils.isBlank(null));
        assertTrue(ExampleUtils.isBlank(""));
        assertTrue(ExampleUtils.isBlank(" "));
        assertFalse(ExampleUtils.isBlank("abc"));
    }

    public void testFromBeanToString() {
        assertEquals("ExampleBean {name=null, number=null}",
                ExampleUtils.fromBeanToString(new ExampleBean()));
        assertEquals("ExampleBean {name=abc, number=null}",
                ExampleUtils.fromBeanToString(new ExampleBean("abc", null)));
        assertEquals("ExampleBean {name=null, number=123}",
                ExampleUtils.fromBeanToString(new ExampleBean(null, 123)));
        assertEquals("ExampleBean {name=abc, number=123}",
                ExampleUtils.fromBeanToString(new ExampleBean("abc", 123)));
    }

    public void testFromBeanToString_IgnoreNull() {
        assertEquals("ExampleBean",
                ExampleUtils.fromBeanToString(new ExampleBean(), true));
        assertEquals("ExampleBean {name=abc}",
                ExampleUtils.fromBeanToString(new ExampleBean("abc", null), true));
        assertEquals("ExampleBean {number=123}",
                ExampleUtils.fromBeanToString(new ExampleBean(null, 123), true));
        assertEquals("ExampleBean {name=abc, number=123}",
                ExampleUtils.fromBeanToString(new ExampleBean("abc", 123), true));
    }

    static class ExampleBean {
        private String name;
        private Integer number;
        public ExampleBean() {}
        public ExampleBean(String name, Integer number) {
            this.name = name;
            this.number = number;
        }
        public String getName() {
            return name;
        }
        public void setName(String strValue) {
            this.name = strValue;
        }
        public Integer getNumber() {
            return number;
        }
        public void setNumber(Integer intValue) {
            this.number = intValue;
        }
    }

}
