package jp.sourceforge.glad.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class SortedSetAdapter<E> extends SetAdapter<E> {

    public SortedSetAdapter() {
        this(new TreeSet<E>());
    }

    public SortedSetAdapter(SortedSet<E> set) {
        super(set);
    }

    public SortedSet<E> collection() {
        return set();
    }

    public SortedSet<E> set() {
        return (SortedSet<E>) collection;
    }

    // this ∪ {o}

    public SortedSetAdapter<E> add(E o) {
        super.add(o);
        return this;
    }

    // this ∪ c

    public SortedSetAdapter<E> addAll(E... a) {
        super.addAll(a);
        return this;
    }

    public SortedSetAdapter<E> addAll(Collection<? extends E> c) {
        super.addAll(c);
        return this;
    }

    public SortedSetAdapter<E> addAll(CollectionAdapter<? extends E> ca) {
        super.addAll(ca);
        return this;
    }

    public SortedSetAdapter<E> addAll(Iterable<? extends E> i) {
        super.addAll(i);
        return this;
    }

    public SortedSetAdapter<E> addAll(Iterator<? extends E> i) {
        super.addAll(i);
        return this;
    }

    public SortedSetAdapter<E> addAll(Enumeration<? extends E> e) {
        super.addAll(e);
        return this;
    }

    // this - {c}

    public SortedSetAdapter<E> remove(Object o) {
        super.remove(o);
        return this;
    }

    // this - c

    public SortedSetAdapter<E> removeAll(Object... a) {
        super.removeAll(a);
        return this;
    }

    public SortedSetAdapter<E> removeAll(Collection<?> c) {
        super.removeAll(c);
        return this;
    }

    public SortedSetAdapter<E> removeAll(CollectionAdapter<?> ca) {
        super.removeAll(ca);
        return this;
    }

    // this ∩ c

    public SortedSetAdapter<E> retainAll(E... a) {
        super.retainAll(a);
        return this;
    }

    public SortedSetAdapter<E> retainAll(Collection<?> c) {
        super.retainAll(c);
        return this;
    }

    public SortedSetAdapter<E> retainAll(CollectionAdapter<? extends E> ca) {
        super.retainAll(ca);
        return this;
    }

    public SortedSetAdapter<E> clear() {
        super.clear();
        return this;
    }

    public Comparator<? super E> comparator() {
        return set().comparator();
    }

    public E first() {
        return set().first();
    }

    public E last() {
        return set().last();
    }

    public SortedSet<E> headSet(E to) {
        return set().headSet(to);
    }

    public SortedSet<E> tailSet(E from) {
        return set().tailSet(from);
    }

    public SortedSet<E> subSet(E from, E to) {
        return set().subSet(from, to);
    }

    public SortedSet<E> unmodifiableCollection() {
        return unmodifiableSet();
    }

    public SortedSet<E> unmodifiableSet() {
        return Collections.unmodifiableSortedSet(set());
    }

    public SortedSet<E> synchronizedCollection() {
        return synchronizedSet();
    }

    public SortedSet<E> synchronizedSet() {
        return Collections.synchronizedSortedSet(set());
    }

    public SortedSet<E> checkedCollection(Class<E> type) {
        return checkedSet(type);
    }

    public SortedSet<E> checkedSet(Class<E> type) {
        return Collections.checkedSortedSet(set(), type);
    }

}
