package jp.sourceforge.glad.collection.closure;

import jp.sourceforge.glad.collection.function.Function;

public class ClosureAdapter<S, T> implements Closure<S> {

    private final Function<S, T> converter;

    private final Closure<T> closure;

    public ClosureAdapter(Function<S, T> converter, Closure<T> closure) {
        this.converter = converter;
        this.closure = closure;
    }

    public ClosureAdapter(Closure<T> closure, Function<S, T> converter) {
        this(converter, closure);
    }

    /**
     * このコンストラクタを使用する場合は、convert(S) メソッドをオーバライドしてください。
     * 
     * @param closure Closure
     */
    protected ClosureAdapter(Closure<T> closure) {
        this(null, closure);
    }

    public void execute(S source) throws Exception {
        closure.execute(convert(source));
    }

    protected T convert(S source) throws Exception {
        return converter.apply(source);
    }

}
