package jp.sourceforge.glad.collection.exception;

import jp.sourceforge.glad.util.ValueHolder;
import jp.sourceforge.glad.util.ValueReader;

public class ReturnException extends ControlException {

    private static final long serialVersionUID = 1L;

    final ValueReader<?> result;

    public ReturnException() {
        this((ValueReader<?>) null);
    }

    public ReturnException(Object result) {
        this(new ValueHolder<Object>(result));
    }

    ReturnException(ValueReader<?> result) {
        this.result = result;
    }

    @SuppressWarnings("unchecked")
    public <T> T getResult() {
        return (T) result.get();
    }

    public String toString() {
        if (result == null) {
            return "return";
        } else {
            return "return " + result.get();
        }
    }

}
