package jp.sourceforge.glad.dsl.xhtml;

import jp.sourceforge.glad.dsl.xml.DOCTYPE;
import jp.sourceforge.glad.dsl.xml.XmlDocument;
import jp.sourceforge.glad.dsl.xml.XmlElement;

public interface XhtmlDocument<T extends XhtmlDocument<T>>
        extends XmlDocument<T> {

    // ---- META

    String CONTENT_TYPE = "Content-Type";

    // ---- LINK

    String STYLESHEET = "Stylesheet";

    @Deprecated
    T add(XmlElement<?> element);
    T add(HTML html);

    DOCTYPE DOCTYPE_xhtml10_strict();
    DOCTYPE DOCTYPE_xhtml10_transitional();

    DOCTYPE DOCTYPE_xhtml11_strict();
    @Deprecated
    DOCTYPE DOCTYPE_xhtml11_transitional();

    // ---- The global structure of an HTML document

    HTML html();
    HEAD head();
    TITLE title();
    META meta();

    BODY body();
    DIV div();
    SPAN span();
    H1 h1();
    H2 h2();
    H3 h3();
    //H4 h4();
    //H5 h5();
    //H6 h6();
    //ADDRESS address();

    // ---- Language information and text direction

    //BDO bdo();

    // ---- Text
/*
    EM em();
    STRONG strong();
    DFN dfn();
    CODE code();
    SAMP samp();
    KBD kbd();
    VAR var();
    CITE cite();
    ABBR abbr();
    ACRONYM acronym();
    BLOCKQUOTE blockquote();
    Q q();
    SUB sub();
    SUP sup();
*/
    P p();
    BR br();
    PRE pre();
/*
    INS ins();
    DEL del();
*/
    // ---- Lists

    UL ul();
    OL ol();
    LI li();
    DL dl();
    DT dt();
    DD dd();

    // ---- Tables

    TABLE table();
    CAPTION caption();
    THEAD thead();
    TFOOT tfoot();
    TBODY tbody();
    COLGROUP colgroup();
    COL col();
    TR tr();
    TH th();
    TD td();

    // ---- Links

    A a();
    LINK link();
    //BASE base();

    // ---- Objects, Images, and Applets
/*
    IMG img();
    OBJECT object();
    PARAM param();
    APPLET applet();
    MAP map();
    AREA area();
*/
    // ---- Style Sheets

    //STYLE style();

    // ---- Alignment, font styles, and horizontal rules

    //HR hr();

    // ---- Frames
/*
    FRAMESET frameset();
    FRAME frame();
    NOFRAMES noframes();
    IFRAME iframe();
*/
    // ---- Forms
/*
    FORM form();
    INPUT input();
    BUTTON button();
    SELECT select();
    OPTGROUP optgroup();
    OPTION option();
    TEXTAREA textarea();
    LABEL label();
    FIELDSET fieldset();
    LEGEND legend();
*/
    // ---- Scripts
/*
    SCRIPT script();
    NOSCRIPT noscript();
*/
}
