package jp.sourceforge.glad.jdbc;

import java.sql.SQLException;

public class SqlRuntimeException extends RuntimeException {

    private static final long serialVersionUID = -5394524603325736971L;

    private String sqlState;

    private int errorCode;

    public SqlRuntimeException() {
    }

    public SqlRuntimeException(String message) {
        super(message);
    }

    public SqlRuntimeException(Throwable cause) {
        super(cause);
    }

    public SqlRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public SqlRuntimeException(SQLException e) {
        this(e.getMessage(), e);
        this.sqlState = e.getSQLState();
        this.errorCode = e.getErrorCode();
    }

    public String getSQLState() {
        return sqlState;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public SQLException getSQLException() {
        Throwable cause = getCause();
        if (SQLException.class.isInstance(cause)) {
            return SQLException.class.cast(cause);
        } else {
            return new SQLException(
                    getMessage(), getSQLState(), getErrorCode());
        }
    }

}
