package jp.sourceforge.glad.math;

import java.math.BigDecimal;
import java.math.BigInteger;

import jp.sourceforge.glad.math.internal.NumberContext;

public class NumberAdapter {

    final NumberContext context;

    public NumberAdapter() {
        this(new NumberContext());
    }

    public NumberAdapter(int value) {
        this(new NumberContext(value));
    }

    public NumberAdapter(long value) {
        this(new NumberContext(value));
    }

    public NumberAdapter(BigInteger value) {
        this(new NumberContext(value));
    }

    public NumberAdapter(BigDecimal value) {
        this(new NumberContext(value));
    }

    NumberAdapter(NumberContext context) {
        this.context = context;
    }

    public Number get() {
        return context.getValue();
    }

    public int intValue() {
        return context.intValue();
    }

    public long longValue() {
        return context.longValue();
    }

    public BigInteger toBigInteger() {
        return context.toBigInteger();
    }

    public BigDecimal toBigDecimal() {
        return context.toBigDecimal();
    }

    public NumberAdapter set(int value) {
        context.setValue(value);
        return this;
    }

    public NumberAdapter set(long value) {
        context.setValue(value);
        return this;
    }

    public NumberAdapter set(BigInteger value) {
        context.setValue(value);
        return this;
    }

    public NumberAdapter set(BigDecimal value) {
        context.setValue(value);
        return this;
    }

    public NumberAdapter add(int value) {
        context.getState().add(context, value);
        return this;
    }

    public NumberAdapter add(long value) {
        context.getState().add(context, value);
        return this;
    }

    public NumberAdapter add(BigInteger value) {
        context.getState().add(context, value);
        return this;
    }

    public NumberAdapter add(BigDecimal value) {
        context.getState().add(context, value);
        return this;
    }

    public NumberAdapter subtract(int value) {
        context.getState().subtract(context, value);
        return this;
    }

    public NumberAdapter subtract(long value) {
        context.getState().subtract(context, value);
        return this;
    }

    public NumberAdapter subtract(BigInteger value) {
        context.getState().subtract(context, value);
        return this;
    }

    public NumberAdapter subtract(BigDecimal value) {
        context.getState().subtract(context, value);
        return this;
    }

    public NumberAdapter multiply(int value) {
        context.getState().multiply(context, value);
        return this;
    }

    public NumberAdapter multiply(long value) {
        context.getState().multiply(context, value);
        return this;
    }

    public NumberAdapter multiply(BigInteger value) {
        context.getState().multiply(context, value);
        return this;
    }

    public NumberAdapter multiply(BigDecimal value) {
        context.getState().multiply(context, value);
        return this;
    }

    public NumberAdapter divide(int value) {
        context.getState().divide(context, value);
        return this;
    }

    public NumberAdapter divide(long value) {
        context.getState().divide(context, value);
        return this;
    }

    public NumberAdapter divide(BigInteger value) {
        context.getState().divide(context, value);
        return this;
    }

    public NumberAdapter divide(BigDecimal value) {
        context.getState().divide(context, value);
        return this;
    }

    public String toString() {
        return context.toString();
    }

}
