package jp.sourceforge.glad.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

public class FieldAdapter<T> {

    final Field field;

    public FieldAdapter(Class<?> clazz, String name) {
        this(ReflectionUtils.getDeclaredField(clazz, name));
    }

    public FieldAdapter(Field field) {
        this.field = field;
    }

    public Class<?> getDeclaringClass() {
        return field.getDeclaringClass();
    }

    public String getName() {
        return field.getName();
    }

    public int getModifiers() {
        return field.getModifiers();
    }

    public boolean isEnumConstant() {
        return field.isEnumConstant();
    }

    public boolean isSynthetic() {
        return field.isSynthetic();
    }

    public Class<?> getType() {
        return field.getType();
    }

    public Type getGenericType() {
        return field.getGenericType();
    }

    public T get(Object target) {
        return ReflectionUtils.<T>get(field, target);
    }

    public void set(Object target, T value) {
        ReflectionUtils.set(field, target, value);
    }

    public boolean isAccessible() {
        return field.isAccessible();
    }

    public void setAccessible(boolean accessible) {
        field.setAccessible(accessible);
    }

    public void makeAccessible() {
        ReflectionUtils.makeAccessible(field);
    }

    public Annotation[] getAnnotations() {
        return field.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return field.getDeclaredAnnotations();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return field.getAnnotation(annotationClass);
    }

    public boolean isAnnotationPresent(
            Class<? extends Annotation> annotationClass) {
        return field.isAnnotationPresent(annotationClass);
    }

    public String toString() {
        return ReflectionUtils.toString(field);
    }

    public String toGenericString() {
        return field.toGenericString();
    }

}
