package jp.sourceforge.glad.reflect;

public class IllegalAccessRuntimeException extends ReflectionRuntimeException {

    private static final long serialVersionUID = 5303244527808198252L;

    public IllegalAccessRuntimeException() {
    }

    public IllegalAccessRuntimeException(String message) {
        super(message);
    }

    public IllegalAccessRuntimeException(Throwable cause) {
        super(cause);
    }

    public IllegalAccessRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public IllegalAccessRuntimeException(IllegalAccessException e) {
        this(e.getMessage(), e);
    }

    public IllegalAccessException getIllegalAccessException() {
        Throwable cause = getCause();
        if (IllegalAccessException.class.isInstance(cause)) {
            return IllegalAccessException.class.cast(cause);
        } else {
            return new IllegalAccessException(getMessage());
        }
    }

}
