package jp.sourceforge.glad.calendar.holiday;

import java.util.Locale;

import jp.sourceforge.glad.calendar.ISOCalendar;
import junit.framework.TestCase;

/**
 * {@link Holiday} の単体テスト。
 *
 * @author GLAD!!
 */
public class HolidayTest extends TestCase {

    public void testGanjitsu() {
        Holiday holiday = new Holiday(
                "JP", "Ganjitsu", "01-01", 1948, null);
        assertEquals("JP", holiday.getCountry());
        assertEquals("Ganjitsu", holiday.getRawName());
        assertEquals("元日", holiday.getName());
        assertEquals("元日", holiday.getName(Locale.JAPAN));
        assertEquals("New Year's Day", holiday.getName(Locale.US));
        assertEquals(1, holiday.getMonth());
        assertEquals(1, holiday.getDayOfMonth());
        assertEquals(0, holiday.getWeekOfMonth());
        assertEquals(0, holiday.getDayOfWeek());
        assertEquals(1948, holiday.getStartYear());
        assertNull(holiday.getEndYear());
        assertFalse(holiday.isAvailableYear(1947));
        assertTrue (holiday.isAvailableYear(1948));
        assertTrue (holiday.isAvailableYear(2008));
        assertEquals("2008-01-01T00:00:00.000", holiday.getISOCalendar(2008));
        assertEquals("Ganjitsu: 01-01", holiday.toString());
    }

    public void testSeijinNoHi() {
        Holiday holiday = new Holiday(
                "JP", "Seijin-no-hi", "01-15", null, 1999);
        assertEquals("JP", holiday.getCountry());
        assertEquals("Seijin-no-hi", holiday.getRawName());
        assertEquals("成人の日", holiday.getName());
        assertEquals("成人の日", holiday.getName(Locale.JAPAN));
        assertEquals("Coming of Age Day", holiday.getName(Locale.US));
        assertEquals( 1, holiday.getMonth());
        assertEquals(15, holiday.getDayOfMonth());
        assertEquals( 0, holiday.getWeekOfMonth());
        assertEquals( 0, holiday.getDayOfWeek());
        assertNull(holiday.getStartYear());
        assertEquals(1999, holiday.getEndYear());
        assertTrue (holiday.isAvailableYear(1948));
        assertTrue (holiday.isAvailableYear(1999));
        assertFalse(holiday.isAvailableYear(2000));
        try {
            holiday.getISOCalendar(2008);
            fail();
        } catch (IllegalArgumentException e) {}
        assertEquals("Seijin-no-hi: 01-15", holiday.toString());
    }

    public void testSeijinNoHi2() {
        Holiday holiday = new Holiday(
                "JP", "Seijin-no-hi", "01-W2-1", 2000, null);
        assertEquals("JP", holiday.getCountry());
        assertEquals("Seijin-no-hi", holiday.getRawName());
        assertEquals("成人の日", holiday.getName());
        assertEquals("成人の日", holiday.getName(Locale.JAPAN));
        assertEquals("Coming of Age Day", holiday.getName(Locale.US));
        assertEquals(1, holiday.getMonth());
        assertEquals(0, holiday.getDayOfMonth());
        assertEquals(2, holiday.getWeekOfMonth());
        assertEquals(1, holiday.getDayOfWeek());
        assertEquals(2000, holiday.getStartYear());
        assertNull(holiday.getEndYear());
        assertFalse(holiday.isAvailableYear(1999));
        assertTrue (holiday.isAvailableYear(2000));
        assertTrue (holiday.isAvailableYear(2008));
        assertEquals("2008-01-14T00:00:00.000", holiday.getISOCalendar(2008));
        assertEquals("Seijin-no-hi: 01-W2-1", holiday.toString());
    }

    static void assertEquals(int expected, Integer actual) {
        assertEquals(Integer.valueOf(expected), actual);
    }

    static void assertEquals(String expected, ISOCalendar calendar) {
        assertEquals(expected, calendar.formatDateTime());
    }

}
