package jp.sourceforge.glad.math;

import java.math.BigDecimal;
import java.math.BigInteger;

import junit.framework.TestCase;

public class NumberAdapterTest extends TestCase {

    public void testDefault() {
        NumberAdapter n = new NumberAdapter();
        assertEquals(Integer.class, n.get().getClass());
        assertEquals(0, n.intValue());
        assertEquals(0L, n.longValue());
        assertEquals(BigInteger.ZERO, n.toBigInteger());
        assertEquals(BigDecimal.ZERO, n.toBigDecimal());
        assertEquals("0", n.toString());
    }

    public void testInt() {
        NumberAdapter n = new NumberAdapter(123);
        assertEquals(Integer.class, n.get().getClass());
        assertEquals(123, n.intValue());
        assertEquals(123L, n.longValue());
        assertEquals("123", n.toBigInteger());
        assertEquals("123", n.toBigDecimal());
        assertEquals("123", n.toString());
        
        assertSame(n, n.add(234));
        assertEquals(Integer.class, n.get().getClass());
        assertEquals(357, n.intValue());
        
        assertSame(n, n.subtract(345));
        assertEquals(Integer.class, n.get().getClass());
        assertEquals(12, n.intValue());
        
        assertSame(n, n.multiply(456));
        assertEquals(Integer.class, n.get().getClass());
        assertEquals(5472, n.intValue());
        
        assertSame(n, n.divide(12));
        assertEquals(Integer.class, n.get().getClass());
        assertEquals(456, n.intValue());
    }

    public void testLong() {
        NumberAdapter n = new NumberAdapter(123L);
        assertEquals(Long.class, n.get().getClass());
        assertEquals(123, n.intValue());
        assertEquals(123L, n.longValue());
        assertEquals("123", n.toBigInteger());
        assertEquals("123", n.toBigDecimal());
        assertEquals("123", n.toString());
        
        assertSame(n, n.add(234));
        assertEquals(Long.class, n.get().getClass());
        assertEquals(357L, n.longValue());
        
        assertSame(n, n.subtract(345));
        assertEquals(Long.class, n.get().getClass());
        assertEquals(12L, n.longValue());
        
        assertSame(n, n.multiply(456));
        assertEquals(Long.class, n.get().getClass());
        assertEquals(5472L, n.longValue());
        
        assertSame(n, n.divide(12));
        assertEquals(Long.class, n.get().getClass());
        assertEquals(456L, n.longValue());
    }

    public void testBigInteger() {
        NumberAdapter n = new NumberAdapter(new BigInteger("123"));
        assertEquals(BigInteger.class, n.get().getClass());
        assertEquals(123, n.intValue());
        assertEquals(123L, n.longValue());
        assertEquals("123", n.toBigInteger());
        assertEquals("123", n.toBigDecimal());
        assertEquals("123", n.toString());
        
        assertSame(n, n.add(234));
        assertEquals(BigInteger.class, n.get().getClass());
        assertEquals("357", n.toBigInteger());
        
        assertSame(n, n.subtract(345));
        assertEquals(BigInteger.class, n.get().getClass());
        assertEquals("12", n.toBigInteger());
        
        assertSame(n, n.multiply(456));
        assertEquals(BigInteger.class, n.get().getClass());
        assertEquals("5472", n.toBigInteger());
        
        assertSame(n, n.divide(12));
        assertEquals(BigInteger.class, n.get().getClass());
        assertEquals("456", n.toBigInteger());
    }

    public void testBigDecimal() {
        NumberAdapter n = new NumberAdapter(new BigDecimal("1.23"));
        assertEquals(BigDecimal.class, n.get().getClass());
        assertEquals(1, n.intValue());
        assertEquals(1L, n.longValue());
        assertEquals("1", n.toBigInteger());
        assertEquals("1.23", n.toBigDecimal());
        assertEquals("1.23", n.toString());
        
        assertSame(n, n.add(new BigDecimal("2.34")));
        assertEquals(BigDecimal.class, n.get().getClass());
        assertEquals("3.57", n.toBigDecimal());
        
        assertSame(n, n.subtract(new BigDecimal("3.45")));
        assertEquals(BigDecimal.class, n.get().getClass());
        assertEquals("0.12", n.toBigDecimal());
        
        assertSame(n, n.multiply(456));
        assertEquals(BigDecimal.class, n.get().getClass());
        assertEquals("54.72", n.toBigDecimal());
        
        assertSame(n, n.divide(12));
        assertEquals(BigDecimal.class, n.get().getClass());
        assertEquals("4.56", n.toBigDecimal());
    }

    static void assertEquals(String expected, BigInteger actual) {
        assertEquals(new BigInteger(expected), actual);
    }

    static void assertEquals(String expected, BigDecimal actual) {
        assertEquals(new BigDecimal(expected), actual);
    }

}
