package com.example.mule.transformer;

import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;

import com.example.mule.util.MuleExampleUtils;

public class ToStringTransformer extends AbstractTransformer {

    public ToStringTransformer() {
        registerSourceType(Object.class);
        setReturnClass(String.class);
    }

    protected Object doTransform(Object src, String encoding)
            throws TransformerException {
        return MuleExampleUtils.toString(src);
    }

}
