package com.example.echo.client;

import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;

import junit.framework.TestCase;

import com.example.echo.client.axis2axisRE.EchoAxisRE_ServiceLocator;
import com.example.echo.client.axis2axisWL.EchoAxisWL_ServiceLocator;
import com.example.echo.client.axis2cxf.EchoServiceLocator;

public class EchoAxisClientTest extends TestCase {

    static final String ENDPOINT_BASE =
            "http://localhost:8080/mule-example/services/";

    public void testEchoAxisSA_withCall() throws Exception {
        Service service = new Service();
        Call call = (Call) service.createCall();
        call.setTargetEndpointAddress(
                "http://localhost:65082/services/echoAxis");
        call.setOperationName(
                new QName("http://simple.component.api.mule.org", "echo"));
        assertEquals("Hello!", call.invoke(new Object[] {"Hello!"}));
    }

    public void testEchoAxisRE_withCall() throws Exception {
        Service service = new Service();
        Call call = (Call) service.createCall();
        call.setTargetEndpointAddress(ENDPOINT_BASE + "echoAxisRE");
        call.setOperationName(
                new QName("http://simple.component.api.mule.org", "echo"));
        assertEquals("Hello!", call.invoke(new Object[] {"Hello!"}));
    }

    public void testEchoAxisRE_withStub() throws Exception {
        com.example.echo.client.axis2axisRE.Echo port =
                new EchoAxisRE_ServiceLocator().getechoAxisRE();
        assertEquals("Hello!", port.echo("Hello!"));
    }

    public void testEchoAxisRE_withStub_checkError() throws Exception {
        com.example.echo.client.axis2axisRE.Echo port =
                new EchoAxisRE_ServiceLocator().getechoAxisRE();
        assertEquals("ERROR!!", port.echo("error"));
    }

    public void testEchoAxisRE_withStub_checkException() throws Exception {
        com.example.echo.client.axis2axisRE.Echo port =
                new EchoAxisRE_ServiceLocator().getechoAxisRE();
        try {
            port.echo("exception");
            fail();
        } catch (AxisFault e) {
            e.printStackTrace();
        }
    }

    public void testEchoAxisWL_withCall() throws Exception {
        Service service = new Service();
        Call call = (Call) service.createCall();
        call.setTargetEndpointAddress(ENDPOINT_BASE + "echoAxisWL");
        call.setOperationStyle(Style.WRAPPED);
        call.setOperationUse(Use.LITERAL);
        call.setOperationName(
                new QName("http://simple.component.api.mule.org", "echo"));
        call.addParameter(
                new QName("http://simple.component.api.mule.org", "text"),
                Constants.XSD_STRING, ParameterMode.IN);
        call.setReturnType(Constants.XSD_STRING);
        assertEquals("Hello!", call.invoke(new Object[] {"Hello!"}));
    }

    public void testEchoAxisWL_withStub() throws Exception {
        com.example.echo.client.axis2axisWL.Echo port =
                new EchoAxisWL_ServiceLocator().getechoAxisWL();
        assertEquals("Hello!", port.echo("Hello!"));
    }

    public void testEchoAxisWL_withStub_checkError() throws Exception {
        com.example.echo.client.axis2axisWL.Echo port =
                new EchoAxisWL_ServiceLocator().getechoAxisWL();
        assertEquals("ERROR!!", port.echo("error"));
    }

    public void testEchoAxisWL_withStub_checkException() throws Exception {
        com.example.echo.client.axis2axisWL.Echo port =
                new EchoAxisWL_ServiceLocator().getechoAxisWL();
        try {
            port.echo("exception");
            fail();
        } catch (AxisFault e) {
            e.printStackTrace();
        }
    }

    public void testEchoAxisWL2RE_withCall() throws Exception {
        Service service = new Service();
        Call call = (Call) service.createCall();
        call.setTargetEndpointAddress(ENDPOINT_BASE + "echoAxisWL2RE");
        call.setOperationStyle(Style.WRAPPED);
        call.setOperationUse(Use.LITERAL);
        call.setOperationName(
                new QName("http://simple.component.api.mule.org", "echo"));
        call.addParameter(
                new QName("http://simple.component.api.mule.org", "text"),
                Constants.XSD_STRING, ParameterMode.IN);
        call.setReturnType(Constants.XSD_STRING);
        //assertEquals("Hello!", call.invoke(new Object[] {"Hello!"}));
        assertEquals("Hello!", call.invoke(new Object[] {"error"}));
    }

    public void testEchoCxf_withStub() throws Exception {
        com.example.echo.client.axis2cxf.Echo port =
                new EchoServiceLocator().getEchoPort();
        assertEquals("Hello!", port.echo("Hello!"));
    }

}
