package test.org.mule.routing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.example.mule.util.MuleExampleUtils;

public class ExternalComponent {

    static final Log log = LogFactory.getLog(ExternalComponent.class);

    public Object doSomething(Object arg) throws Exception {
        if (log.isInfoEnabled()) {
            MuleExampleUtils.logPayload(log, "Called: ", arg);
        }
        if ("failure@external".equals(arg)) {
            String result = "FAILURE!! (@external)";
            log.warn(result);
            return result;
        }
        if ("exception@external".equals(arg)) {
            RuntimeException e =
                    new RuntimeException("EXCEPTION!! (@external)");
            log.warn(e);
            throw e;
        }
        log.info("OK!!");
        return arg;
    }

}
