package test.org.mule.routing.inbound;

import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;

import test.org.mule.routing.MessageReceiver;
import test.org.mule.tck.FunctionalTestCase;

public class ForwardingRouterTest extends FunctionalTestCase {

    static final String URL = "vm://ForwardingRouter";
    static final String OUTBOUND_URL = "vm://OutOnly";

    static final long TIMEOUT = 3000;
    static final long SHORT_TIMEOUT = 500;

    protected String getConfigResources() {
        return "test/org/mule/routing/inbound/ForwardingRouterTest-config.xml";
    }

    public void testDispatch_OK() throws Exception {
        MuleClient client = new MuleClient();
        MessageReceiver receiver = new MessageReceiver(client);
        client.dispatch(URL, "abc", null);
        assertNull(receiver.get(SHORT_TIMEOUT));
        MuleMessage result = client.request(OUTBOUND_URL, TIMEOUT);
        assertEquals("abc", result.getPayload());
    }

    public void testDispatch_FailureAtComponent() throws Exception {
        MuleClient client = new MuleClient();
        MessageReceiver receiver = new MessageReceiver(client);
        client.dispatch(URL, "failure@component", null);
        assertNull(receiver.get(SHORT_TIMEOUT));
        MuleMessage result = client.request(OUTBOUND_URL, TIMEOUT);
        assertEquals("failure@component", result.getPayload());
    }

    public void testDispatch_ExceptionAtComponent() throws Exception {
        MuleClient client = new MuleClient();
        MessageReceiver receiver = new MessageReceiver(client);
        client.dispatch(URL, "exception@component", null);
        assertNull(receiver.get(SHORT_TIMEOUT));
        MuleMessage result = client.request(OUTBOUND_URL, TIMEOUT);
        assertEquals("exception@component", result.getPayload());
    }

}
