#
# test_OrthogonalArray.rb
#
# Copyright (C) 2010 GLAD!! (ITO Yoshiichi)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific language
# governing permissions and limitations under the License.
#

require 'test/unit'
require 'logger'
require 'OrthogonalArray'

class OrthogonalArrayTest < Test::Unit::TestCase

  @@log = Logger.new(STDOUT)
  @@log.level = Logger::WARN
  @@log.formatter = proc {|s, d, p, m| sprintf("\n%-5s %s: %s", s, p, m) }

  def test_L4
    oa = OrthogonalArray.new(4)
    @@log.debug('L4') { oa.table.inspect }
    assert oa.valid?
    assert_equal(100, oa.rating(2))
    assert_equal( 50, oa.rating(3))
    assert_equal(  2, oa.strength)
    assert_equal('OA(4; 2^3)', oa.summary)
  end

  def test_L8
    oa = OrthogonalArray.new(8)
    @@log.debug('L8') { oa.table.inspect }
    assert_equal(142, oa.rating(2).to_i)
    assert_equal( 62, oa.rating(3).to_i)
    assert_equal( 27, oa.rating(4).to_i)
    assert_equal( 12, oa.rating(5).to_i)
    assert_equal(  2, oa.strength)
    assert_equal('OA(8; 4^1, 2^4)', oa.summary)
  end

  def test_L16
    oa = OrthogonalArray.new(16)
    @@log.debug('L16') { oa.table.inspect }
    assert oa.valid?
    assert_equal(100, oa.rating(2))
    assert_equal( 25, oa.rating(3))
    assert_equal(  6, oa.rating(4).to_i)
    assert_equal(  1, oa.rating(5).to_i)
    assert_equal(  2, oa.strength)
    assert_equal('OA(16; 4^5)', oa.summary)
  end

  def test_L32
    oa = OrthogonalArray.new(32)
    @@log.debug('L32') { oa.table.inspect }
    assert oa.valid?
    assert_equal(163, oa.rating(2).to_i)
    assert_equal( 37, oa.rating(3).to_i)
    assert_equal(  2, oa.strength)
    assert_equal(  2, oa.strength)
    assert_equal('OA(32; 8^1, 4^8)', oa.summary)
  end

  def test_L64
    oa = OrthogonalArray.new(64)
    @@log.debug('L64') { oa.table.inspect }
    assert oa.valid?
    assert_equal(100, oa.rating(2))
    assert_equal( 12, oa.rating(3).to_i)
    assert_equal(  2, oa.strength)
    assert_equal('OA(64; 8^9)', oa.summary)
  end

  def test_L128
    oa = OrthogonalArray.new(128)
    @@log.debug('L128') { oa.table.inspect }
    assert oa.valid?
    assert_equal(178, oa.rating(2).to_i)
    #assert_equal( 21, oa.rating(3).to_i)
    #assert_equal(  2, oa.strength)
    #assert_equal('OA(128; 16^1, 8^16)', oa.summary)
  end

  def test_L256
    oa = OrthogonalArray.new(256)
    @@log.debug('L256') { oa.table.inspect }
    assert oa.valid?
    assert_equal(100, oa.rating(2))
    #assert_equal(  6, oa.rating(3).to_i)
    #assert_equal(  2, oa.strength)
    #assert_equal('OA(256; 16^17)', oa.summary)
  end

  def test_make_values
    oa = OrthogonalArray.new(8, '4^1')
    values = oa.make_values([1, 2])
    assert_equal([[0, 0], [0, 1], [1, 0], [1, 1],
                  [2, 0], [2, 1], [3, 0], [3, 1]], values)
    values = oa.make_values([2, 4])
    assert_equal([[0, 0], [0, 1], [1, 0], [1, 1]], values)
    values = oa.make_values([2, 3, 5])
    assert_equal([[0, 0, 0], [0, 0, 1], [0, 1, 0], [0, 1, 1],
                  [1, 0, 0], [1, 0, 1], [1, 1, 0], [1, 1, 1]], values)
  end

end
