package jp.sourceforge.glad.org.seasar.dao.tiger.dto;

import java.math.BigDecimal;
import java.sql.Date;

import jp.sourceforge.glad.org.seasar.dao.tiger.entity.Department;
import jp.sourceforge.glad.org.seasar.dao.tiger.entity.Employee;

import org.seasar.dao.annotation.tiger.Relation;

public class EmployeeDto extends Employee {

    private static final long serialVersionUID = 8778865488966624182L;

    @Relation(relationNo = 0)
    protected Department department;

    public EmployeeDto() {
    }

    public EmployeeDto(
            long empNo,
            String ename,
            String job,
            Integer manager,
            Date hireDate,
            BigDecimal salary,
            Double commission,
            int deptNo) {
        super(empNo, ename, job, manager, hireDate, salary, commission, deptNo);
    }

    public void setDeptNo(int deptNo) {
        if (this.deptNo != deptNo) {
            this.deptNo = deptNo;
            department = null;
        }
        invariant();
    }

    public Department getDepartment() {
        return department;
    }

    public void setDepartment(Department department) {
        if (this.department != department) {
            this.department = department;
            if (department != null) {
                deptNo = department.getDeptNo();
            }
        }
        invariant();
    }

    protected void invariant() {
        assert department == null || department.getDeptNo() == deptNo;
    }

}
