package jp.sourceforge.glad.org.seasar.dao.tiger.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

import org.seasar.dao.annotation.tiger.Bean;
import org.seasar.dao.annotation.tiger.Column;

@Bean(table = "EMP")
public class Employee implements Serializable {

    private static final long serialVersionUID = 8784752763852652595L;

    protected long empNo;

    protected String ename;

    protected String job;

    @Column("MGR")
    protected Integer manager;

    protected Date hireDate;

    @Column("SAL")
    protected BigDecimal salary;

    @Column("COMM")
    protected Double commission;

    protected int deptNo;

    @Column("TSTAMP")
    protected Timestamp timestamp;

    public Employee() {
    }

    public Employee(
            long empNo,
            String ename,
            String job,
            Integer manager,
            Date hireDate,
            BigDecimal salary,
            Double commission,
            int deptNo) {
        this.empNo = empNo;
        this.ename = ename;
        this.job = job;
        this.manager = manager;
        this.hireDate = hireDate;
        this.salary = salary;
        this.commission = commission;
        this.deptNo = deptNo;
    }

    public long getEmpNo() {
        return empNo;
    }

    public void setEmpNo(long empNo) {
        this.empNo = empNo;
    }

    public String getEname() {
        return ename;
    }

    public void setEname(String ename) {
        this.ename = ename;
    }

    public String getJob() {
        return job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public Integer getManager() {
        return manager;
    }

    public void setManager(Integer manager) {
        this.manager = manager;
    }

    public Date getHireDate() {
        return hireDate;
    }

    public void setHireDate(Date hireDate) {
        this.hireDate = hireDate;
    }

    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }

    public Double getCommission() {
        return commission;
    }

    public void setCommission(Double commission) {
        this.commission = commission;
    }

    public int getDeptNo() {
        return deptNo;
    }

    public void setDeptNo(int deptNo) {
        this.deptNo = deptNo;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public int hashCode() {
        return Long.valueOf(empNo).hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Employee)) {
            return false;
        }
        Employee castOther = (Employee) other;
        return empNo == castOther.empNo;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" {empNo=").append(empNo);
        sb.append(", ename=").append(ename);
        sb.append(", job=").append(job);
        sb.append(", manager=").append(manager);
        sb.append(", hireDate=").append(hireDate);
        sb.append(", salary=").append(salary);
        sb.append(", commission=").append(commission);
        sb.append(", deptNo=").append(deptNo);
        sb.append(", timestamp=").append(timestamp);
        sb.append('}');
        return sb.toString();
    }

}
