package jp.sourceforge.glad.org.seasar.framework.model.impl;

import java.util.Arrays;
import java.util.List;

import jp.sourceforge.glad.org.seasar.framework.model.domain.Person;
import jp.sourceforge.glad.org.seasar.framework.model.repository.PersonRepository;

import org.seasar.framework.unit.S2FrameworkTestCase;

/**
 * {@link ModelHelperImpl}の単体テスト。
 * 
 * @author GLAD!!
 */
public class ModelHelperImplTest extends S2FrameworkTestCase {

    ModelHelperImpl helper;
    PersonRepository repository;

    protected void setUp() throws Exception {
        include("ModelHelperImplTest.dicon");
    }

    /**
     * {@link ModelHelperImpl#injectDependency}で、
     * オブジェクト単体が渡された場合。
     */
    public void testInjectDependency() {
        final Person person = new Person("Hoge", 12);
        helper.injectDependency(person);
        // ModelにRepositoryがDIされていること。
        assertSame(repository, person.getRepository());
        
        person.save();
        // ModelにDIされたRepositoryが呼び出されたこと。
        assertPersonEquals(person, repository.getPerson("Hoge"));
    }

    /**
     * {@link ModelHelperImpl#injectDependency}で、
     * オブジェクトの配列が渡された場合。
     */
    public void testInjectDependencyArray() {
        final Person hoge = new Person("Hoge", 12);
        final Person fuga = new Person("Fuga", 23);
        final Person[] people = {hoge, fuga};
        helper.injectDependency(people);
        // ModelにRepositoryがDIされていること。
        assertSame(repository, hoge.getRepository());
        assertSame(repository, fuga.getRepository());

        hoge.save();
        fuga.save();
        // ModelにDIされたRepositoryが呼び出されたこと。
        assertPersonEquals(hoge, repository.getPerson("Hoge"));
        assertPersonEquals(fuga, repository.getPerson("Fuga"));
    }

    /**
     * {@link ModelHelperImpl#injectDependency}で、
     * オブジェクトのコレクションが渡された場合。
     */
    public void testInjectDependencyCollection() {
        final Person hoge = new Person("Hoge", 12);
        final Person fuga = new Person("Fuga", 23);
        final List<Person> people = Arrays.asList(hoge, fuga);
        helper.injectDependency(people);
        // ModelにRepositoryがDIされていること。
        assertSame(repository, hoge.getRepository());
        assertSame(repository, fuga.getRepository());

        hoge.save();
        fuga.save();
        // ModelにDIされたRepositoryが呼び出されたこと。
        assertPersonEquals(hoge, repository.getPerson("Hoge"));
        assertPersonEquals(fuga, repository.getPerson("Fuga"));
    }

    void assertPersonEquals(final Person expected, final Person actual) {
        assertEquals(expected.getName(), actual.getName());
        assertEquals(expected.getAge(), actual.getAge());
    }

}
