package haskell.example;

import haskell.prelude.Function;
import haskell.prelude.Function2;
import haskell.prelude.IO;
import haskell.prelude.Int;
import haskell.prelude.String;
import junit.framework.TestCase;

public class PersonTest extends TestCase {

    protected void setUp() throws java.lang.Exception {
    }

    public void testPerson() {
        final Person x1 = new Person(String.valueOf("Foo"), Int.valueOf(12));
        System.out.println(x1);
        IO.print(x1);
        
        final String name = Person.name(x1);
        System.out.println(name);
        IO.print(name);
        assertEquals(String.valueOf("Foo"), name);
        
        final Person x2 = Person.setName(String.valueOf("Bar"), x1);
        System.out.println(x2);
        IO.print(x2);
        assertEquals(String.valueOf("Bar"), Person.name(x2));
        
        final Int age = Person.age(x2);
        System.out.println(age);
        IO.print(age);
        assertEquals(Int.valueOf(12), age);
        
        final Person x3 = Person.setAge(Int.valueOf(23), x2);
        System.out.println(x3);
        IO.print(x3);
        assertEquals(Int.valueOf(23), Person.age(x3));
    }

    public void testFunction() {
        final Person x1 = new Person(String.valueOf("Foo"), Int.valueOf(12));
        System.out.println(x1);
        IO.print(x1);
        
        final Function<Person, String> fName
                = new Function<Person, String>(
                        Person.class, String.class, "name");
        System.out.println(fName);
        final String name = fName.apply(x1);
        System.out.println(name);
        IO.print(name);
        assertEquals(String.valueOf("Foo"), name);
        
        final Function2<String, Person, Person> fSetName
                = new Function2<String, Person, Person>(
                        Person.class, Person.class, "setName");
        System.out.println(fSetName);
        final Person x2 = fSetName.apply(String.valueOf("Bar"), x1.eval());
        System.out.println(x2);
        IO.print(x2);
        assertEquals(String.valueOf("Bar"), Person.name(x2));
        
        final Function<Person, Int> fAge
                = new Function<Person, Int>(Person.class, Int.class, "age");
        System.out.println(fAge);
        final Int age = fAge.apply(x2);
        System.out.println(age);
        IO.print(age);
        assertEquals(Int.valueOf(12), age);
        
        final Function2<Int, Person, Person> fSetAge
                = new Function2<Int, Person, Person>(
                        Person.class, Person.class, "setAge");
        System.out.println(fSetAge);
        final Person x3 = fSetAge.apply(Int.valueOf(23), x2.eval());
        System.out.println(x3);
        IO.print(x3);
        assertEquals(Int.valueOf(23), Person.age(x3));
    }

}
