package jp.sourceforge.glad.example.domain.sale.entity;

import java.util.List;

import jp.sourceforge.glad.example.domain.common.value.Date;
import jp.sourceforge.glad.example.domain.common.value.Money;
import jp.sourceforge.glad.example.domain.common.value.Time;

/**
 * 販売。
 */
public class Sale {

	private Long id;

	private long version;

	private Date date;

	private Time time;

	private List<SalesLineItem> lineItems;

	public List<SalesLineItem> getLineItems() {
		return lineItems;
	}

	public Money getTotal() {
		Money total = Money.ZERO;
		for (SalesLineItem lineItem : getLineItems()) {
			total = total.add(lineItem.getSubtotal());
		}
		return total;
	}

}
