package jp.sourceforge.glad.example.service.hello.impl;

import jp.sourceforge.glad.example.service.hello.dto.MessageDto;
import junit.framework.TestCase;

public class HelloServiceImplTest extends TestCase {

    HelloServiceImpl service;

    protected void setUp() throws Exception {
        service = new HelloServiceImpl();
    }

    protected void tearDown() throws Exception {
        service = null;
    }

    public void testSayHello() {
        assertMessageEquals("Hello, World!", service.sayHello(null));
    }

    public void testSayHello_withEmpty() {
        assertMessageEquals("Hello, World!", service.sayHello(""));
    }

    public void testSayHello_withName() {
        assertMessageEquals("Hello, Hoge!", service.sayHello("Hoge"));
    }

    void assertMessageEquals(String body, MessageDto message) {
        assertEquals(body, message.getBody());
    }

}
