package jp.sourceforge.glad.collection.closure;

import jp.sourceforge.glad.collection.iteration.IterationUtils;
import jp.sourceforge.glad.collection.predicate.Predicate;

public class PredicateClosure<T> implements Closure<T> {

    private final Predicate<T> predicate;

    public PredicateClosure(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public void execute(T source) throws Exception {
        if (!predicate.evaludate(source)) {
            IterationUtils.doBreak();
        }
    }

}
