package jp.sourceforge.glad.reflect;

public class ClassNotFoundRuntimeException extends ReflectionRuntimeException {

    private static final long serialVersionUID = 8213773805282913994L;

    public ClassNotFoundRuntimeException() {
    }

    public ClassNotFoundRuntimeException(String message) {
        super(message);
    }

    public ClassNotFoundRuntimeException(Throwable cause) {
        super(cause);
    }

    public ClassNotFoundRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public ClassNotFoundRuntimeException(ClassNotFoundException e) {
        this(e.getMessage(), e);
    }

    public ClassNotFoundException getClassNotFoundException() {
        Throwable cause = getCause();
        if (cause instanceof ClassNotFoundException) {
            return (ClassNotFoundException) cause;
        } else {
            return new ClassNotFoundException(getMessage(), cause);
        }
    }

}
