/*
 * Copyright (C) 2008-2009 GLAD!! (ITO Yoshiichi)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.glad.util;

import java.util.Comparator;

/**
 * 自然な順序付けによる比較関数。
 * 
 * @author GLAD!!
 * @param <T> 引数の型
 */
public class ComparableComparator<T extends Comparable<T>>
        implements Comparator<T> {

    /**
     * インスタンスを返します。
     * 
     * @param <T> 引数の型
     * @return インスタンス
     */
    @SuppressWarnings("unchecked")
    public static <T extends Comparable<T>> Comparable<T> getInstance() {
        return (Comparable<T>) instance;
    }

    /**
     * 2つの引数を比較します。
     * 
     * @param o1 比較対象の引数1
     * @param o2 比較対象の引数2
     * @return o1 < o2 の場合は負の整数、
     *         o1 = o2 の場合は0、
     *         o1 > o2 の場合は正の整数
     */
    public int compare(T o1, T o2) {
        return o1.compareTo(o2);
    }

    @SuppressWarnings("unchecked")
    static final ComparableComparator instance =
            new ComparableComparator();

}
